<?php
require_once '../config.php';
requireLogin();

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $pixelId = sanitize($_POST['facebook_pixel_id'] ?? '');
    $accessToken = sanitize($_POST['facebook_access_token'] ?? '');
    
    try {
        $stmt = $pdo->prepare("
            UPDATE settings 
            SET facebook_pixel_id = ?, facebook_access_token = ?, updated_at = NOW()
            WHERE id = 1
        ");
        $stmt->execute([$pixelId, $accessToken]);
        setFlash('success', 'Settings updated successfully');
        header('Location: settings.php');
        exit;
    } catch(PDOException $e) {
        setFlash('error', 'Failed to update settings');
    }
}

// Get current settings
$settings = getSettings($pdo);
$flash = getFlash();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - Prime Institute Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="admin-style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="admin-container">
        <?php include 'includes/sidebar.php'; ?>
        
        <main class="main-content">
            <div class="page-header">
                <h1>⚙️ Settings</h1>
                <p>Configure system settings</p>
            </div>
            
            <?php if ($flash): ?>
            <div class="alert alert-<?php echo $flash['type']; ?>">
                <?php echo htmlspecialchars($flash['message']); ?>
            </div>
            <?php endif; ?>
            
            <div class="content-card">
                <h3>📊 Facebook Pixel Configuration</h3>
                <p style="color: #6b7280; margin: 10px 0 20px;">
                    Configure Facebook Pixel to track sales and payment confirmation events.
                </p>
                
                <form method="POST">
                    <div class="form-group">
                        <label>Facebook Pixel ID</label>
                        <input type="text" name="facebook_pixel_id" 
                               value="<?php echo htmlspecialchars($settings['facebook_pixel_id'] ?? ''); ?>"
                               placeholder="Enter your Facebook Pixel ID">
                        <small style="color: #6b7280; display: block; margin-top: 5px;">
                            Find your Pixel ID in Facebook Events Manager
                        </small>
                    </div>
                    
                    <div class="form-group">
                        <label>Facebook Access Token (Optional)</label>
                        <textarea name="facebook_access_token" rows="3" 
                                  placeholder="Enter Facebook Conversions API Access Token (for server-side events)"><?php echo htmlspecialchars($settings['facebook_access_token'] ?? ''); ?></textarea>
                        <small style="color: #6b7280; display: block; margin-top: 5px;">
                            For advanced tracking using Facebook Conversions API
                        </small>
                    </div>
                    
                    <div class="form-actions">
                        <button type="submit" class="btn btn-primary">Save Settings</button>
                    </div>
                </form>
                
                <div style="margin-top: 30px; padding: 20px; background: #f0f9ff; border-radius: 8px; border-left: 4px solid #3b82f6;">
                    <h4 style="color: #1e40af; margin-bottom: 10px;">📖 How to Setup Facebook Pixel</h4>
                    <ol style="color: #1e3a8a; line-height: 1.8;">
                        <li>Go to <a href="https://business.facebook.com/events_manager" target="_blank" style="color: #3b82f6;">Facebook Events Manager</a></li>
                        <li>Select your Pixel or create a new one</li>
                        <li>Copy the Pixel ID (usually 15-16 digits)</li>
                        <li>Paste it in the field above and save</li>
                        <li>The system will automatically track:
                            <ul style="margin-top: 5px;">
                                <li><strong>PageView + ViewContent:</strong> When user visits the landing page</li>
                                <li><strong>Lead:</strong> When user submits enrollment form</li>
                                <li><strong>InitiateCheckout:</strong> When user reaches payment page</li>
                                <li><strong>Purchase:</strong> When payment is confirmed</li>
                            </ul>
                        </li>
                    </ol>
                </div>
            </div>
            
            <div class="content-card" style="margin-top: 20px;">
                <h3>🔐 Change Admin Password</h3>
                <p style="color: #6b7280; margin: 10px 0 20px;">
                    For security, please change the default admin password.
                </p>
                
                <form action="change-password.php" method="POST">
                    <div class="form-group">
                        <label>Current Password</label>
                        <input type="password" name="current_password" required>
                    </div>
                    
                    <div class="form-group">
                        <label>New Password</label>
                        <input type="password" name="new_password" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Confirm New Password</label>
                        <input type="password" name="confirm_password" required>
                    </div>
                    
                    <div class="form-actions">
                        <button type="submit" class="btn btn-primary">Change Password</button>
                    </div>
                </form>
            </div>
        </main>
    </div>
</body>
</html>
