<?php
require_once '../config.php';
requireLogin();

// Get statistics
try {
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM orders WHERE payment_status = 'pending'");
    $pendingOrders = $stmt->fetch()['total'];
    
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM orders WHERE payment_status = 'completed'");
    $confirmedOrders = $stmt->fetch()['total'];
    
    $stmt = $pdo->query("SELECT SUM(amount) as total FROM orders WHERE payment_status = 'completed'");
    $totalRevenue = $stmt->fetch()['total'] ?? 0;
    
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM payment_gateways WHERE status = 1");
    $activeGateways = $stmt->fetch()['total'];
    
} catch(PDOException $e) {
    $pendingOrders = $confirmedOrders = $totalRevenue = $activeGateways = 0;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Prime Institute Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="admin-style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="admin-container">
        <?php include 'includes/sidebar.php'; ?>
        
        <main class="main-content">
            <div class="page-header">
                <h1>📊 Dashboard</h1>
                <p>Welcome back, <?php echo htmlspecialchars($_SESSION['admin_username']); ?>!</p>
            </div>
            
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-icon" style="background: #fef3c7;">
                        <span style="color: #f59e0b;">⏳</span>
                    </div>
                    <div class="stat-info">
                        <div class="stat-label">Pending Orders</div>
                        <div class="stat-value"><?php echo $pendingOrders; ?></div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon" style="background: #d1fae5;">
                        <span style="color: #10b981;">✅</span>
                    </div>
                    <div class="stat-info">
                        <div class="stat-label">Confirmed Orders</div>
                        <div class="stat-value"><?php echo $confirmedOrders; ?></div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon" style="background: #dbeafe;">
                        <span style="color: #3b82f6;">💰</span>
                    </div>
                    <div class="stat-info">
                        <div class="stat-label">Total Revenue</div>
                        <div class="stat-value">৳<?php echo number_format($totalRevenue, 0); ?></div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon" style="background: #e0e7ff;">
                        <span style="color: #667eea;">💳</span>
                    </div>
                    <div class="stat-info">
                        <div class="stat-label">Active Gateways</div>
                        <div class="stat-value"><?php echo $activeGateways; ?></div>
                    </div>
                </div>
            </div>
            
            <div class="dashboard-grid">
                <div class="dashboard-card">
                    <h3>Recent Orders</h3>
                    <?php
                    try {
                        $stmt = $pdo->query("SELECT * FROM orders ORDER BY created_at DESC LIMIT 5");
                        $recentOrders = $stmt->fetchAll();
                    } catch(PDOException $e) {
                        $recentOrders = [];
                    }
                    ?>
                    <div class="orders-list">
                        <?php if (empty($recentOrders)): ?>
                            <p style="text-align: center; color: #9ca3af; padding: 20px;">No orders yet</p>
                        <?php else: ?>
                            <?php foreach ($recentOrders as $order): ?>
                            <div class="order-item">
                                <div>
                                    <strong><?php echo htmlspecialchars($order['name']); ?></strong>
                                    <span style="color: #6b7280; font-size: 0.9rem;">
                                        - <?php echo htmlspecialchars($order['order_id']); ?>
                                    </span>
                                </div>
                                <span class="status-badge status-<?php echo $order['payment_status']; ?>">
                                    <?php echo ucfirst($order['payment_status']); ?>
                                </span>
                            </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                    <a href="pending-orders.php" class="view-all-link">View All Orders →</a>
                </div>
                
                <div class="dashboard-card">
                    <h3>Quick Actions</h3>
                    <div class="quick-actions">
                        <a href="pending-orders.php" class="action-btn">
                            <span>⏳</span>
                            <div>
                                <strong>Pending Orders</strong>
                                <small><?php echo $pendingOrders; ?> waiting</small>
                            </div>
                        </a>
                        <a href="payment-gateways.php" class="action-btn">
                            <span>💳</span>
                            <div>
                                <strong>Payment Gateways</strong>
                                <small>Manage gateways</small>
                            </div>
                        </a>
                        <a href="settings.php" class="action-btn">
                            <span>⚙️</span>
                            <div>
                                <strong>Settings</strong>
                                <small>Configure system</small>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
