<?php
require_once 'config.php';

$orderId = $_GET['order'] ?? '';

if (empty($orderId)) {
    header('Location: index.php');
    exit;
}

// Get order details
try {
    $stmt = $pdo->prepare("SELECT * FROM orders WHERE order_id = ?");
    $stmt->execute([$orderId]);
    $order = $stmt->fetch();
    
    if (!$order) {
        setFlash('error', 'Order not found');
        header('Location: index.php');
        exit;
    }
} catch(PDOException $e) {
    setFlash('error', 'Database error');
    header('Location: index.php');
    exit;
}

// Get bKash API configuration
try {
    $stmt = $pdo->prepare("SELECT * FROM payment_gateways WHERE gateway_type = 'bkash' AND type = 'automatic' AND status = 1");
    $stmt->execute();
    $bkashConfig = $stmt->fetch();
    
    if (!$bkashConfig) {
        setFlash('error', 'bKash payment gateway is not configured or disabled');
        header('Location: payment.php?order=' . $orderId);
        exit;
    }
} catch(PDOException $e) {
    setFlash('error', 'Failed to load payment gateway');
    header('Location: payment.php?order=' . $orderId);
    exit;
}

// bKash API Configuration
$username = $bkashConfig['api_username'];
$password = $bkashConfig['api_password'];
$appKey = $bkashConfig['api_app_key'];
$appSecret = $bkashConfig['api_app_secret'];
$isSandbox = $bkashConfig['is_sandbox'];

// Set API base URL
$baseUrl = $isSandbox 
    ? 'https://tokenized.sandbox.bka.sh/v1.2.0-beta' 
    : 'https://tokenized.pay.bka.sh/v1.2.0-beta';

$callbackUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") 
    . "://" . $_SERVER['HTTP_HOST'] . "/bkash_callback.php";

// Step 1: Get Grant Token
function getBkashToken($baseUrl, $appKey, $appSecret, $username, $password) {
    $url = $baseUrl . '/tokenized/checkout/token/grant';
    
    $headers = [
        'Content-Type: application/json',
        'Accept: application/json',
        'username: ' . $username,
        'password: ' . $password
    ];
    
    $body = json_encode([
        'app_key' => $appKey,
        'app_secret' => $appSecret
    ]);
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        return ['error' => $error];
    }
    
    return json_decode($response, true);
}

// Step 2: Create Payment
function createBkashPayment($baseUrl, $appKey, $token, $amount, $orderId, $callbackUrl) {
    $url = $baseUrl . '/tokenized/checkout/create';
    
    $headers = [
        'Content-Type: application/json',
        'Accept: application/json',
        'Authorization: ' . $token,
        'X-APP-Key: ' . $appKey
    ];
    
    $body = json_encode([
        'mode' => '0011',
        'payerReference' => $orderId,
        'callbackURL' => $callbackUrl,
        'amount' => $amount,
        'currency' => 'BDT',
        'intent' => 'sale',
        'merchantInvoiceNumber' => $orderId
    ]);
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        return ['error' => $error];
    }
    
    return json_decode($response, true);
}

// Get token
$tokenResponse = getBkashToken($baseUrl, $appKey, $appSecret, $username, $password);

if (isset($tokenResponse['error']) || !isset($tokenResponse['id_token'])) {
    $errorMsg = $tokenResponse['error'] ?? ($tokenResponse['statusMessage'] ?? 'Failed to connect to bKash');
    ?>
    <!DOCTYPE html>
    <html lang="bn">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>bKash Payment Error - Prime Institute</title>
        
        <!-- Meta Pixel Code -->
        <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
        n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t,s)}(window, document,'script',
        'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '1180786514222470');
        fbq('track', 'PageView');
        </script>
        <noscript><img height="1" width="1" style="display:none"
        src="https://www.facebook.com/tr?id=1180786514222470&ev=PageView&noscript=1"
        /></noscript>
        <!-- End Meta Pixel Code -->
        
        <style>
            * { margin: 0; padding: 0; box-sizing: border-box; }
            body { font-family: 'Hind Siliguri', sans-serif; background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%); min-height: 100vh; display: flex; align-items: center; justify-content: center; }
            .error-card { background: #1e293b; padding: 40px; border-radius: 16px; text-align: center; max-width: 500px; margin: 20px; }
            .error-icon { font-size: 60px; margin-bottom: 20px; }
            h1 { color: #ef4444; margin-bottom: 15px; }
            p { color: #9ca3af; margin-bottom: 20px; }
            .error-details { background: #0f172a; padding: 15px; border-radius: 8px; color: #f87171; font-size: 14px; margin-bottom: 20px; text-align: left; word-break: break-all; }
            .btn { display: inline-block; padding: 12px 30px; background: #e2136e; color: white; text-decoration: none; border-radius: 8px; font-weight: 600; }
            .btn:hover { background: #c01160; }
        </style>
    </head>
    <body>
        <div class="error-card">
            <div class="error-icon">❌</div>
            <h1>bKash Connection Failed</h1>
            <p>Unable to connect to bKash payment gateway. Please try again or choose a different payment method.</p>
            <div class="error-details">
                <strong>Error:</strong> <?php echo htmlspecialchars($errorMsg); ?>
            </div>
            <a href="payment.php?order=<?php echo htmlspecialchars($orderId); ?>" class="btn">← Back to Payment</a>
        </div>
    </body>
    </html>
    <?php
    exit;
}

$idToken = $tokenResponse['id_token'];

// Store token in session for callback
$_SESSION['bkash_token'] = $idToken;
$_SESSION['bkash_order'] = $orderId;

// Create payment
$amount = number_format($order['amount'], 2, '.', '');
$paymentResponse = createBkashPayment($baseUrl, $appKey, $idToken, $amount, $orderId, $callbackUrl);

if (isset($paymentResponse['error']) || !isset($paymentResponse['bkashURL'])) {
    $errorMsg = $paymentResponse['error'] ?? ($paymentResponse['statusMessage'] ?? 'Failed to create payment');
    ?>
    <!DOCTYPE html>
    <html lang="bn">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Payment Error - Prime Institute</title>
        
        <!-- Meta Pixel Code -->
        <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
        n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t,s)}(window, document,'script',
        'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '1180786514222470');
        fbq('track', 'PageView');
        </script>
        <noscript><img height="1" width="1" style="display:none"
        src="https://www.facebook.com/tr?id=1180786514222470&ev=PageView&noscript=1"
        /></noscript>
        <!-- End Meta Pixel Code -->
        
        <style>
            * { margin: 0; padding: 0; box-sizing: border-box; }
            body { font-family: 'Hind Siliguri', sans-serif; background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%); min-height: 100vh; display: flex; align-items: center; justify-content: center; }
            .error-card { background: #1e293b; padding: 40px; border-radius: 16px; text-align: center; max-width: 500px; margin: 20px; }
            .error-icon { font-size: 60px; margin-bottom: 20px; }
            h1 { color: #ef4444; margin-bottom: 15px; }
            p { color: #9ca3af; margin-bottom: 20px; }
            .error-details { background: #0f172a; padding: 15px; border-radius: 8px; color: #f87171; font-size: 14px; margin-bottom: 20px; text-align: left; word-break: break-all; }
            .btn { display: inline-block; padding: 12px 30px; background: #e2136e; color: white; text-decoration: none; border-radius: 8px; font-weight: 600; }
            .btn:hover { background: #c01160; }
        </style>
    </head>
    <body>
        <div class="error-card">
            <div class="error-icon">❌</div>
            <h1>Payment Creation Failed</h1>
            <p>Unable to create bKash payment. Please try again or choose a different payment method.</p>
            <div class="error-details">
                <strong>Error:</strong> <?php echo htmlspecialchars($errorMsg); ?>
            </div>
            <a href="payment.php?order=<?php echo htmlspecialchars($orderId); ?>" class="btn">← Back to Payment</a>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// Store payment ID for callback
$_SESSION['bkash_payment_id'] = $paymentResponse['paymentID'];

// Update order with payment ID
try {
    $stmt = $pdo->prepare("UPDATE orders SET transaction_id = ? WHERE order_id = ?");
    $stmt->execute([$paymentResponse['paymentID'], $orderId]);
} catch(PDOException $e) {
    // Continue anyway
}

// Redirect to bKash payment page
header('Location: ' . $paymentResponse['bkashURL']);
exit;
