<?php
require_once '../config.php';
requireLogin();

// Get confirmed orders
try {
    $stmt = $pdo->query("
        SELECT o.*, pg.name as gateway_name 
        FROM orders o 
        LEFT JOIN payment_gateways pg ON o.payment_gateway_id = pg.id
        WHERE o.payment_status = 'completed' 
        ORDER BY o.updated_at DESC
    ");
    $orders = $stmt->fetchAll();
} catch(PDOException $e) {
    $orders = [];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirmed Orders - Prime Institute Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="admin-style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="admin-container">
        <?php include 'includes/sidebar.php'; ?>
        
        <main class="main-content">
            <div class="page-header">
                <h1>✅ Confirmed Orders</h1>
                <p>Successfully completed payments</p>
            </div>
            
            <div class="content-card">
                <div class="table-container">
                    <?php if (empty($orders)): ?>
                        <p style="text-align: center; padding: 40px; color: #9ca3af;">No confirmed orders yet</p>
                    <?php else: ?>
                    <table>
                        <thead>
                            <tr>
                                <th>Order ID</th>
                                <th>Customer</th>
                                <th>Email</th>
                                <th>Phone</th>
                                <th>Amount</th>
                                <th>Gateway</th>
                                <th>Transaction ID</th>
                                <th>Payment Phone</th>
                                <th>Payment Proof</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($orders as $order): ?>
                            <tr>
                                <td><strong><?php echo htmlspecialchars($order['order_id']); ?></strong></td>
                                <td><?php echo htmlspecialchars($order['name']); ?></td>
                                <td><?php echo htmlspecialchars($order['email']); ?></td>
                                <td><?php echo htmlspecialchars($order['phone']); ?></td>
                                <td>৳<?php echo number_format($order['amount'], 0); ?></td>
                                <td><?php echo htmlspecialchars($order['gateway_name'] ?? 'N/A'); ?></td>
                                <td><?php echo htmlspecialchars($order['transaction_id'] ?? '-'); ?></td>
                                <td><?php echo htmlspecialchars($order['payment_phone'] ?? '-'); ?></td>
                                <td>
                                    <?php if (!empty($order['payment_proof'])): ?>
                                        <a href="../uploads/<?php echo htmlspecialchars($order['payment_proof']); ?>" 
                                           target="_blank" class="btn btn-sm" 
                                           style="background: #3b82f6; color: white;">
                                            📷 View
                                        </a>
                                        <button type="button" class="btn btn-sm" 
                                                style="background: #8b5cf6; color: white;" 
                                                onclick="showImageModal('../uploads/<?php echo htmlspecialchars($order['payment_proof']); ?>')">
                                            🔍
                                        </button>
                                    <?php else: ?>
                                        <span style="color: #9ca3af;">-</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo date('d M Y, h:i A', strtotime($order['updated_at'])); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                    <?php endif; ?>
                </div>
            </div>
        </main>
    </div>
    
    <!-- Image Modal -->
    <div id="imageModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.9); z-index: 10000; justify-content: center; align-items: center;">
        <span onclick="closeImageModal()" style="position: absolute; top: 20px; right: 30px; color: white; font-size: 40px; cursor: pointer;">&times;</span>
        <img id="modalImage" style="max-width: 90%; max-height: 90%; border-radius: 8px;">
    </div>
    
    <script>
        function showImageModal(src) {
            document.getElementById('modalImage').src = src;
            document.getElementById('imageModal').style.display = 'flex';
        }
        
        function closeImageModal() {
            document.getElementById('imageModal').style.display = 'none';
        }
        
        document.getElementById('imageModal').addEventListener('click', function(e) {
            if (e.target === this) closeImageModal();
        });
        
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') closeImageModal();
        });
    </script>
</body>
</html>
