<?php
require_once 'config.php';

$paymentID = $_GET['paymentID'] ?? '';
$status = $_GET['status'] ?? '';

$orderId = $_SESSION['bkash_order'] ?? '';
$token = $_SESSION['bkash_token'] ?? '';
$storedPaymentId = $_SESSION['bkash_payment_id'] ?? '';

// Validate
if (empty($orderId) || empty($token)) {
    setFlash('error', 'Session expired. Please try again.');
    header('Location: index.php');
    exit;
}

// Get bKash configuration
try {
    $stmt = $pdo->prepare("SELECT * FROM payment_gateways WHERE gateway_type = 'bkash' AND type = 'automatic' AND status = 1");
    $stmt->execute();
    $bkashConfig = $stmt->fetch();
    
    if (!$bkashConfig) {
        setFlash('error', 'Payment gateway configuration error');
        header('Location: payment.php?order=' . $orderId);
        exit;
    }
} catch(PDOException $e) {
    setFlash('error', 'Database error');
    header('Location: payment.php?order=' . $orderId);
    exit;
}

$appKey = $bkashConfig['api_app_key'];
$isSandbox = $bkashConfig['is_sandbox'];

$baseUrl = $isSandbox 
    ? 'https://tokenized.sandbox.bka.sh/v1.2.0-beta' 
    : 'https://tokenized.pay.bka.sh/v1.2.0-beta';

// Handle different statuses
if ($status === 'cancel') {
    // User cancelled the payment
    try {
        $stmt = $pdo->prepare("UPDATE orders SET status = 'cancelled' WHERE order_id = ?");
        $stmt->execute([$orderId]);
    } catch(PDOException $e) {}
    
    setFlash('error', 'Payment was cancelled');
    header('Location: payment.php?order=' . $orderId);
    exit;
}

if ($status === 'failure') {
    // Payment failed
    try {
        $stmt = $pdo->prepare("UPDATE orders SET status = 'failed' WHERE order_id = ?");
        $stmt->execute([$orderId]);
    } catch(PDOException $e) {}
    
    setFlash('error', 'Payment failed. Please try again.');
    header('Location: payment.php?order=' . $orderId);
    exit;
}

if ($status === 'success' && !empty($paymentID)) {
    // Execute the payment
    $url = $baseUrl . '/tokenized/checkout/execute';
    
    $headers = [
        'Content-Type: application/json',
        'Accept: application/json',
        'Authorization: ' . $token,
        'X-APP-Key: ' . $appKey
    ];
    
    $body = json_encode([
        'paymentID' => $paymentID
    ]);
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        setFlash('error', 'Failed to verify payment: ' . $error);
        header('Location: payment.php?order=' . $orderId);
        exit;
    }
    
    $result = json_decode($response, true);
    
    if (isset($result['statusCode']) && $result['statusCode'] === '0000' && $result['transactionStatus'] === 'Completed') {
        // Payment successful
        $trxID = $result['trxID'] ?? $paymentID;
        
        try {
            $stmt = $pdo->prepare("
                UPDATE orders 
                SET status = 'confirmed', 
                    payment_status = 'paid',
                    transaction_id = ?,
                    payment_gateway = 'bKash Automatic',
                    paid_at = NOW()
                WHERE order_id = ?
            ");
            $stmt->execute([$trxID, $orderId]);
            
            // Clear session
            unset($_SESSION['bkash_token']);
            unset($_SESSION['bkash_order']);
            unset($_SESSION['bkash_payment_id']);
            
            // Redirect to success page
            header('Location: success.php?order=' . $orderId);
            exit;
            
        } catch(PDOException $e) {
            setFlash('error', 'Payment received but failed to update order. Please contact support with your Transaction ID: ' . $trxID);
            header('Location: payment.php?order=' . $orderId);
            exit;
        }
    } else {
        // Payment not completed
        $errorMsg = $result['statusMessage'] ?? 'Payment verification failed';
        
        try {
            $stmt = $pdo->prepare("UPDATE orders SET status = 'failed' WHERE order_id = ?");
            $stmt->execute([$orderId]);
        } catch(PDOException $e) {}
        
        setFlash('error', 'Payment failed: ' . $errorMsg);
        header('Location: payment.php?order=' . $orderId);
        exit;
    }
}

// Unknown status
setFlash('error', 'Unknown payment status');
header('Location: payment.php?order=' . $orderId);
exit;
